function [Dist,D,k,w]=timewarp(t,r,distancefun)
%Dynamic Time Warping Algorithm
%Dist is unnormalized distance between t and r
%D is the accumulated distance matrix
%k is the normalizing factor - not used in this implementation
%w is the optimal path
%t is the first matrix
%r is the second matrix
[trows,N]=size(t);
[rrows,M]=size(r);

for ti=1:trows
    for ri=1:rrows
      % Note this is very inefficient as large parts of the
      % distance matrix may never be reached.
        d(ti,ri)=pdist([t(ti,:);r(ri,:)],distancefun);
    end
end
 
D=zeros(size(d));
D(1,1)=d(1,1);

for n=2:trows
    D(n,1)=d(n,1)+D(n-1,1);
end
for m=2:rrows
    D(1,m)=d(1,m)+D(1,m-1);
end
for n=2:trows
    for m=2:rrows
      % comment about inefficiency applies here too.
        D(n,m)=d(n,m)+min([D(n-1,m),D(n-1,m-1),D(n,m-1)]);
    end
end

Dist=D(trows,rrows);
n=trows;
m=rrows;
k=1;
w=[];
w(1,:)=[trows,rrows];
while ((n+m)~=2)
    if (n-1)==0
        m=m-1;
    elseif (m-1)==0
        n=n-1;
    else 
      [values,number]=min([D(n-1,m),D(n,m-1),D(n-1,m-1)]);
      switch number
      case 1
        n=n-1;
      case 2
        m=m-1;
      case 3
        n=n-1;
        m=m-1;
      end
  end
    k=k+1;
    w=cat(1,w,[n,m]);
end
