function dur = getVoicedDur(ppfile)
% Trawl through the ppfile, and calculate the duration of the voiced
% section. If two consecutive values are more than 0.01666 seconds apart,
% we assume voicing has been interrupted, as frequency just fell below
% 60 Hz.

threshold = 0.01666;

pp = textread(ppfile, '%f');

dur = 0.0;

for i=2:length(pp)
  if pp(i) - pp(i-1) < threshold
    dur = dur + pp(i) - pp(i-1);
  end
end
