function [synchFun,w,area]  = ...
    trackSynch(file1,file2,ppfile)
%
%  trachSynch produces a quantitative estimate of asynchrony among the
%  two time-aligned files, file1 and file2. 
%
%  The estimate is arrived at by performing dynamic time warping to
%  map one file onto the other.  The area under the warp curve is
%  proportional to the asynchrony (in arbitrary units).
%
%  How it works:
%      Read in speech files
%      Convert to cepstra
%      Do DTW and store the resulting warp path
%      Use areaUnderFun.m to calculate the area

disp(['Starting trackSynch...']);
disp(['  File 1: ',file1])
disp(['  File 2: ', file2]);
disp(['  File 3: ', ppfile]);

cepparms = 'Ma';
ncep = 12;
sr = 44100;
framesize = 1024;

sa = wavread(file1);
sb = wavread(file2);

% Make cepstral feature vectors
ca = melcepst(sa,sr,cepparms,ncep);
[sizea,cols] = size(ca);
cb = melcepst(sb,sr,cepparms,ncep);
[sizeb,cols] = size(cb);

% Do dynamic time warp
[Dist,D,k,w]=timewarp(ca,cb,'euclidean');


% Convert it into a function of time
dt = (framesize/2)/sr;
% when we take a non-diagonal step, our delta-t is smaller....
smalldt = 0.5*dt;

offset = [];
times = [];
[nrows,ncols] = size(w);
ix = nrows; 
count = 1;

time = dt;
times(1) = time;
offset(count) = w(ix,1) - w(ix,2);

while ix > 1
    count = count+1;
    ix = ix - 1;
    offset(count) = w(ix,1) - w(ix,2);
    if  (w(ix,1) - w(ix+1,1)) == (w(ix,2) - w(ix+1,2))  % diagonal step in DTW algorithm
        time = time + dt;
    else                                                            % non-diagonal step
        time = time + smalldt;
    end
    times(count) = time;
end
synchFun = [times',offset'];

[yi, pp, area] = areaUnderFun(synchFun,ppfile);

% Normalize the score, by dividing by the duration of the voiced portion

dur = getVoicedDur(ppfile);
area = area/dur;
disp(sprintf('%s %f','trackSynch finished...  area = ', area));
