function [yi, pp, area] = areaUnderFun(fun, ppfile)
% areaUnderFun
%
% pass in a n x 2 array, interpreted as x in first column, and
% matched y in 2nd column
% x-values are not assumed to be equally spaced
%
% We first use interpolation to obtain values of the function y at
% x-values corresponding to the time points in the ppfile.  These all
% come from voiced parts of the signal.
%
% For each point among the new x-values, get the length of the
% interval half way to
% the preceding and following point.  Multiply this by the value of
% y at x, and contribute this to the sum.
% The end points of each interval are not
% included.  We identify breaks in voicing by noting that the gap
% between two pitchpoints is larger than 0.0166 sec (60 Hz)

area = 0.0;

% The ppfile contains a single column of times of estimated pitch
% periods. For our purposes, this is simply an assurance that the
% signal is voiced.

pp = textread(ppfile, '%f');
maxinterval = 0.0166;
yi = interp1(fun(:,1),fun(:,2),pp);

nrows = length(yi);
for i = 2:(nrows-1)
  if pp(i) - pp(i-1) > maxinterval | pp(i+1) - pp(i) > maxinterval
    continue;
  end
  lo = (pp(i) - pp(i-1))/2;
  hi = (pp(i+1) - pp(i))/2;
  bit = (hi + lo)*abs(yi(i));
  area = area + bit;
end

